// shader scripting file for "gnc_monochrome" map
// www.planetquake.com/gnc
// gnc@planetquake.com
// started feb : 06 : 2002
// light images
textures/gnc_monochrome/lightmap10k
{
	qer_editorimage textures/gnc_monochrome/lightmap.tga
	surfaceparm nolightmap
	surfaceparm nomarks
	surfaceparm nonsolid
	q3map_surfacelight 10000
	{
		map textures/gnc_monochrome/lightmap.tga
		rgbGen identity
	}
}

textures/gnc_monochrome/lightmap2k
{
	qer_editorimage textures/gnc_monochrome/lightmap.tga
	surfaceparm nolightmap
	surfaceparm nomarks
        q3map_surfacelight 2000
	{
		map textures/gnc_monochrome/lightmap.tga
		rgbGen identity
	}
}

textures/gnc_monochrome/lightmap5k
{
	qer_editorimage textures/gnc_monochrome/lightmap.tga
	surfaceparm nolightmap
	surfaceparm nomarks
	surfaceparm nonsolid
	q3map_surfacelight 5000
	{
		map textures/gnc_monochrome/lightmap.tga
		rgbGen identity
	}
}

// glass effect
textures/gnc_monochrome/glass
{
	qer_editorimage textures/gnc_monochrome/env0.tga
	surfaceparm nolightmap
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	cull disable
	{
		map textures/gnc_monochrome/env0.tga
		blendfunc add
		rgbGen identity
		tcGen environment 
	}
}

// this will support the lightmap
textures/gnc_monochrome/glass_support_ltmap
{
	qer_editorimage textures/gnc_monochrome/env0.tga
	surfaceparm nolightmap
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	cull disable
	q3map_surfacelight 100
	{
		map textures/gnc_monochrome/env0.tga
		blendfunc add
		rgbGen identity
		tcGen environment 
	}
}

textures/gnc_monochrome/glass_support_ltmap50
{
	qer_editorimage textures/gnc_monochrome/env0.tga
	surfaceparm nolightmap
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	cull disable
	q3map_surfacelight 50
	{
		map textures/gnc_monochrome/env0.tga
		blendfunc add
		rgbGen identity
		tcGen environment 
	}
}

// sky ... space ... emptiness ... whatever ....
textures/gnc_monochrome/blackness
{
	qer_editorimage textures/gnc_monochrome/q3_blackness.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nomarks
	{
		map textures/gnc_monochrome/q3_blackness.tga
	}
}

// teleporter surface
textures/gnc_monochrome/portal
{
	qer_editorimage textures/gnc_monochrome/env0.tga
	surfaceparm nolightmap
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	cull disable
	q3map_surfacelight 100
	{
		map textures/gnc_monochrome/env0.tga
		blendfunc add
		rgbGen identity
		tcGen environment 
	}
	{
		map textures/gnc_monochrome/q3_tesla1.tga
		blendfunc add
		rgbGen identity
		tcMod scroll -0.2 0.1
	}
	{
		map textures/gnc_monochrome/q3_tesla1.tga
		blendfunc add
		rgbGen identity
		tcMod scroll 5 0.1
	}
}

// light beam effect
textures/gnc_monochrome/beam
{
	qer_editorimage textures/gnc_monochrome/q3_beam.tga
	surfaceparm nolightmap
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	cull disable
	{
		map textures/gnc_monochrome/q3_beam.tga
		blendfunc add
		tcMod scroll 0.3 0
	}
}

// below are transparent textures for mending lightmap errors
textures/gnc_monochrome/tex0_black_trans
{
	qer_editorimage textures/gnc_monochrome/tex0_black.tga
	surfaceparm nonsolid
	surfaceparm trans
	{
		map $lightmap 
		rgbGen identity
		tcGen lightmap 
	}
	{
		map textures/gnc_monochrome/tex0_black.tga
		blendfunc filter
		rgbGen identity
	}
}

textures/gnc_monochrome/tex1_darkbrown_trans
{
	qer_editorimage textures/gnc_monochrome/tex1_darkbrown.tga
	surfaceparm nonsolid
	surfaceparm trans
	{
		map $lightmap 
		rgbGen identity
		tcGen lightmap 
	}
	{
		map textures/gnc_monochrome/tex1_darkbrown.tga
		blendfunc filter
		rgbGen identity
	}
}

textures/gnc_monochrome/tex2_lightgrey_trans
{
	qer_editorimage textures/gnc_monochrome/tex2_lightgrey.tga
	surfaceparm nonsolid
	surfaceparm trans
	{
		map $lightmap 
		rgbGen identity
		tcGen lightmap 
	}
	{
		map textures/gnc_monochrome/tex2_lightgrey.tga
		blendfunc filter
		rgbGen identity
	}
}

textures/gnc_monochrome/tex3_brown_trans
{
	qer_editorimage textures/gnc_monochrome/tex3_brown.tga
	surfaceparm nonsolid
	surfaceparm trans
	{
		map $lightmap 
		rgbGen identity
		tcGen lightmap 
	}
	{
		map textures/gnc_monochrome/tex3_brown.tga
		blendfunc filter
		rgbGen identity
	}
}

textures/gnc_monochrome/tex4_blue_trans
{
	qer_editorimage textures/gnc_monochrome/tex4_blue.tga
	surfaceparm nonsolid
	surfaceparm trans
	{
		map $lightmap 
		rgbGen identity
		tcGen lightmap 
	}
	{
		map textures/gnc_monochrome/tex4_blue.tga
		blendfunc filter
		rgbGen identity
	}
}

textures/gnc_monochrome/tex5_darkgrey_trans
{
	qer_editorimage textures/gnc_monochrome/tex5_darkgrey.tga
	surfaceparm nonsolid
	surfaceparm trans
	{
		map $lightmap 
		rgbGen identity
		tcGen lightmap 
	}
	{
		map textures/gnc_monochrome/tex5_darkgrey.tga
		blendfunc filter
		rgbGen identity
	}
}

textures/gnc_monochrome/flare0
{
	qer_editorimage textures/gnc_monochrome/flare0.tga
	cull none
	surfaceparm nolightmap
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	deformVertexes autosprite
	{
		map textures/gnc_monochrome/flare0.tga
		blendfunc add
		rgbGen identity
	}
}
